// link against Linux dependencies
#[cfg(all(unix, not(target_os = "macos")))]
fn main() {
    static_link();
    println!("cargo:rustc-link-arg=-l:sdl2.lib.so");
    println!("cargo:rustc-link-arg=-l:libm.lib.so");
    println!("cargo:rustc-link-arg=-l:libc.lib.so");
}

// static link against debug version of libd1lib.a.
#[cfg(debug_assertions)]
fn static_link() {
    println!("cargo:rustc-link-arg=./target/x86_64-unknown-genode/debug/libd1lib.a");
    //println!("cargo:rustc-link-arg=./target/aarch64-unknown-genode/debug/libd1lib.a");
    println!("cargo:rustc-link-arg=-l:ld.lib.so"); // NOTE: needed for wait_for_continue.
}

// static link against release version of libd1lib.a.
#[cfg(not(debug_assertions))]
fn static_link() {
    println!("cargo:rustc-link-arg=./target/x86_64-unknown-genode/release/libd1lib.a");
    //println!("cargo:rustc-link-arg=./target/aarch64-unknown-genode/release/libd1lib.a");
}
